#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <mpi.h>

int main(int argc, char *argv[]) {
	int r, size, myrank, offset;
	char read_my_rank;

	MPI_File fh;
	MPI_Status s;

	MPI_Init(&argc, &argv);

	MPI_Comm_size(MPI_COMM_WORLD, &size);
	MPI_Comm_rank(MPI_COMM_WORLD, &myrank);

	r = MPI_File_open(MPI_COMM_WORLD, "my-rank.txt", MPI_MODE_RDONLY, MPI_INFO_NULL, &fh);
	// printf("return: %d\n", r);

	for (int i=0; i<10; i++) {
		// Calculates the offset
		offset = (myrank + (i * size)) * sizeof(char);

		MPI_File_read_at(fh, offset, &read_my_rank, 1, MPI_CHAR, &s);

		printf("rank: %d, offset: %03d, read: %c\n", myrank, offset, read_my_rank);
	}

	MPI_File_close(&fh);

	MPI_Finalize();

	return 0;
}
